<script>
</script>
<html>
<head>
  <title>Web3 Metamask Login</title>
  <link href="https://unpkg.com/tailwindcss@^2/dist/tailwind.min.css" rel="stylesheet">
</head>

<body class="flex w-screen h-screen justify-center items-center">
  <div class="flex-col space-y-2 justify-center items-center">
    <button id='loginButton' onclick="" class="mx-auto rounded-md p-2 bg-purple-500 text-white">
      Login with MetaMask
    </button>
    <button  onclick="coinbaseForm()" style="background: black;" onclick="" class="mx-auto rounded-md p-2 bg-purple-500 text-white">
      Login with CoingBase
    </button>
    <p id='userWallet' class='text-lg text-gray-600 my-2'></p>
  </div>

  <script>
    window.userWalletAddress = null
    const loginButton = document.getElementById('loginButton')
    const userWallet = document.getElementById('userWallet')

    function toggleButton() {
      if (!window.ethereum) {
        loginButton.innerText = 'MetaMask is not installed'
        loginButton.classList.remove('bg-purple-500', 'text-white')
        loginButton.classList.add('bg-gray-500', 'text-gray-100', 'cursor-not-allowed')
        return false
      }
      loginButton.addEventListener('click', loginWithMetaMask)
    }

    async function loginWithMetaMask() {
      const accounts = await window.ethereum.request({ method: 'eth_requestAccounts' })
        .catch((e) => {
          console.error(e.message)
          return
        })
      if (!accounts) { return }

      console.log(accounts[0]);

      window.userWalletAddress = accounts[0]
      let walletAddress = accounts[0];
     // var tokenAddress = "0x50f5474724e0ee42d9a4e711ccfb275809fd6d4a";

     // userWallet.innerText = window.userWalletAddress
      loginButton.innerText = 'Sign out of MetaMask'
      window.location.href = "{{ url('verify', []) }}/"+window.userWalletAddress;

      loginButton.removeEventListener('click', loginWithMetaMask)
      setTimeout(() => {
        loginButton.addEventListener('click', signOutOfMetaMask)
      }, 200)
    }

    function signOutOfMetaMask() {
      window.userWalletAddress = null
      userWallet.innerText = ''
      loginButton.innerText = 'Sign in with MetaMask'

      loginButton.removeEventListener('click', signOutOfMetaMask)
      setTimeout(() => {
        loginButton.addEventListener('click', loginWithMetaMask)
      }, 200)
    }

    window.addEventListener('DOMContentLoaded', () => {
      toggleButton()
    });

    function getERC20TokenBalance(tokenAddress, walletAddress, callback) {

      let minABI = [
        // balanceOf
        {
          "constant": true,
          "inputs": [{ "name": "_owner", "type": "address" }],
          "name": "balanceOf",
          "outputs": [{ "name": "balance", "type": "uint256" }],
          "type": "function"
        },
        // decimals
        {
          "constant": true,
          "inputs": [],
          "name": "decimals",
          "outputs": [{ "name": "", "type": "uint8" }],
          "type": "function"
        }
      ];

      let contract = new web3.eth.Contract(minABI).at(tokenAddress);

      contract.balanceOf(walletAddress, (error, balance) => {
        // ERC20トークンの decimals を取得
        contract.decimals((error, decimals) => {
          balance = balance.div(10 ** decimals);
          console.log(balance.toString());
          callback(balance);
        });
      });

    }

    function coinbaseForm(){
      window.location.replace("https://www.coinbase.com/oauth/authorize?client_id=cf5b6e1061c70f60f9bed66bc7dbc37821d3093af39b16f34248561b0418ee7e&redirect_uri=http%3A%2F%2Flocalhost%2Fnft%2Fpublic%2Fsuccess&response_type=code&scope=wallet%3Auser%3Aread");
    }

  </script>
</body>
</html>